import { App } from "@modelcontextprotocol/ext-apps";

//結果を表示させるimgタグ要素
const img = document.getElementById("image") as HTMLImageElement;

//UIのAppを作成
const app = new App({ name: "Get Image App", version: "1.0.0" });

//MCPサーバーからデータが届いた時に実行
const update = (result: any) => {
	//PNG画像のBASE64データを受信
	const data = result.content?.find((c: any) => c.type === "image")?.data;

	//DataURLとして渡す
	if (data) img.src = "data:image/png;base64," + data;
}

//MCPサーバーに要求を送信
const call = async (longitude: number, latitude: number) => {
	const result = await app.callServerTool({
		name: "jaxa-earth-api-get-elevation-image",
		arguments: {
			longitude,
			latitude,
		},
	});

	//結果が届いたら表示を更新
	update(result);
}

//各ボタンを押したときの動作
document.getElementById("fuji")!.addEventListener("click", () => call(138.73, 35.36));
document.getElementById("aso")!.addEventListener("click", () => call(131.08, 32.88));
document.getElementById("yakushima")!.addEventListener("click", () => call(130.52, 30.33));

//サーバーからの結果を受け付ける。app.connect()の前に実行する必要あり。
app.ontoolresult = (result) => {
	update(result);
};

//UIからMCPサーバーに接続
app.connect();