//npm run build-uiの際に利用される設定ファイルです。
//index.htmlではMCPのモジュールを読み込んで単一ファイルにバンドルする必要があるため、
//viteを利用します。

import { defineConfig } from "vite";
import { viteSingleFile } from "vite-plugin-singlefile";

export default defineConfig({

	//MCP Appsでは単一ファイルにバンドルする必要があります。
	plugins: [viteSingleFile()],

	//src-uiフォルダ内のファイルをバンドルして、build内に保存します。
	root: "src-ui",
	build: {
		outDir: "../build",

		//buildフォルダ内には、別途MCPサーバーのソースコードも出力されるため消さないようにします。
		//上書きするのみ
		emptyOutDir: false,
	},
});