
import * as je from "./jaxa.earth.esm.js";

const createCsv_LngLatValue = (dataObject: je.data.DataObject): string => {
	if (dataObject.projection !== "EPSG:4326") {
		//下記の計算では緯度経度が等間隔であることが前提になっているため、EPSG:4326のみ対応
		return `エラーが発生しました。EPSG:4326以外のデータには対応していません。projection = ${dataObject.projection}`;
	}

	const { width, height, bbox } = dataObject;
	const [minLng, minLat, maxLng, maxLat] = bbox;

	const dLng = (maxLng - minLng) / width;
	const dLat = (maxLat - minLat) / height;

	const lines = ["lng,lat,value"];

	for (let j = 0; j < height; j++) {
		const lat = maxLat - (j + 0.5) * dLat;	//ピクセル中心の緯度
		for (let i = 0; i < width; i++) {
			const lng = minLng + (i + 0.5) * dLng;	//ピクセル中心の経度
			lines.push([
				lng.toFixed(4),
				lat.toFixed(4),
				dataObject.data[i + width * j].toFixed(1)
			].join(","));
		}
	}

	return lines.join("\n");
};

//指定した緯度経度の場所周辺のデータを経度、緯度、値を組にしたCSVで返す
export default async (collectionUrl: string, date: Date, band: string, lng: number, lat: number, dl: number): Promise<any> => {

	//指定された緯度経度を中心として±dl度のbboxを作る
	const bbox: je.Bbox = [lng - dl, lat - dl, lng + dl, lat + dl];

	//画像サイズは50px四方（生成AIが読めるコンテキスト長制限内程度で）
	const dataObject = await je.getDataObject({
		collectionUrl,
		date,
		band,
		bbox,
		width: 50,
		height: 50,
	});
	
	//統計値計算を行う(最小値、最大値、平均値など)
	const stat = je.data.globalStat(dataObject);

	return {
		//CSVのデータで返す
		data: createCsv_LngLatValue(dataObject),

		//その他の情報も返す
		bbox,
		min: stat.min,
		max: stat.max,
		mean: stat.mean,
		unit: dataObject.unit,
	};
};