
import * as je from "./jaxa.earth.esm.js";

//指定した緯度経度の場所周辺のデータを画像で返す
export default async (collectionUrl: string, date: Date, band: string, lng: number, lat: number, dl: number): Promise<any> => {

	//指定された緯度経度を中心として±dl度のbboxを作る
	const bbox: je.Bbox = [lng - dl, lat - dl, lng + dl, lat + dl];

	//画像サイズは1000px四方
	const dataObject = await je.getDataObject({
		collectionUrl,
		date,
		band,
		bbox,
		width: 1000,
		height: 1000,
	});
	
	//統計値計算を行う(最小値、最大値、平均値など)
	const stat = je.data.globalStat(dataObject);

	//最小値～最大値を青→赤の虹色に塗るカラーマップ
	const colorMap = new je.image.ColorMap({
		min: stat.min,
		max: stat.max,
		colors: je.Colors.JET,
	});

	return {
		//PNG画像のバイナリデータを作成し、Uint8Arrayの型で返す
		image: await je.image.createPng(dataObject, colorMap),

		//その他の情報も返す
		bbox,
		min: stat.min,
		max: stat.max,
		mean: stat.mean,
		unit: dataObject.unit,
	};
};