
//指定した条件で動作するJavaScriptコードを作成します。
export default (collectionUrl: string, date: Date, band: string, lng: number, lat: number, dl: number): string => {
	
	return `The JavaScript code to retrieve data based on the specified conditions and display the image on the browser is as follows:

\`\`\`js
//Uses the JAXA Earth API for JavaScript module.
//The latest module can be obtained from the link below. Download this file and save it in the same folder as this source code.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/jaxa.earth.esm.js
import * as je from "./jaxa.earth.esm.js";

//Specify the latitude and longitude and range size from which to retrieve data.
const lng = ${lng};
const lat = ${lat};
const dl = ${dl};

//Get a DataObject. This is an object that stores the retrieved data for easy handling.
//It is retrieved at 1000px in width and height.
//For details on each function, please see the pages below.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/interfaces/index.data.DataObject.html
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/functions/index.getDataObject.html
const dataObject = await je.getDataObject({
	collectionUrl: "${collectionUrl}",
	date: new Date("${date.toISOString()}"),
	band: "${band}",
	bbox: [lng - dl, lat - dl, lng + dl, lat + dl],
	width: 1000,
	height: 1000,
});
console.log(dataObject);

//Calculates statistical values.
//For more information on this function, please see the page below.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/functions/index.data.globalStat.html
const stat = je.data.globalStat(dataObject);
console.log(stat);

//Creates a color map for visualization.
//For more information on this function, please see the page below.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/classes/index.image.ColorMap.html
const colorMap = new je.image.ColorMap({
	min: stat.min,
	max: stat.max,
	colors: je.Colors.JET,
});

//Create an HTMLCanvasElement from the DataObject and colormap and display it in the browser.
//For more information on this function, please see the page below.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/functions/index.image.createCanvas.html
document.body.appendChild(je.image.createCanvas(dataObject, colorMap));

//Creates a color map legend image (width 500px, height 30px, font size 10px).
//For more information on this feature, please see the following page.
//https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/classes/index.image.ColorMap.html#createlegendcanvas
document.body.appendChild(colorMap.createLegendCanvas(500, 30, 10, dataObject.unit));
\`\`\`

The above is the JavaScript code that runs in the browser.
Below is an example of HTML to implement that code:

\`\`\`html
<!DOCTYPE html>
<html lang="ja">
<head>
  <meta charset="UTF-8">
  <title>JAXA Earth API</title>
</head>
<body>
  <script type="module">
    
    //Here is the code above.
    
  </script>
</body>
</html>
\`\`\`

Please refer to the following page for more information on creating HTML.
https://data.earth.jaxa.jp/api/javascript/v2.0.0/ja/docs/documents/For_Browsers.html
`;
};