
import * as je from "./jaxa.earth.esm.js";

//指定した条件のデータを返す
export default async (collectionUrl: string, date: Date, band: string, lng: number, lat: number): Promise<any> => {

	//指定された緯度経度を中心として±0.001度の狭い区域でbboxを作る
	const dl = 0.001;
	const bbox: je.Bbox = [lng - dl, lat - dl, lng + dl, lat + dl];

	//DataObjectを取得
	//画像サイズは100px四方
	const dataObject = await je.getDataObject({
		collectionUrl,
		date,
		band,
		bbox,
		width: 100,
		height: 100,
	});

	//統計値計算を行う(最小値、最大値、平均値など)
	const stat = je.data.globalStat(dataObject);

	//平均値meanを返す
	return {
		value: stat.mean,
		unit: dataObject.unit,
	};
};