//このファイルは下記のモジュール単体のテスト用です。
//MCPの実行には利用されません。

import fs from "node:fs";

import getCatalogList from "./getCatalogList.js";
fs.writeFileSync("getCatalogList.txt", await getCatalogList(), "utf8");

import getDocs from "./getDocs.js";
fs.writeFileSync("getDocs.txt", await getDocs(), "utf8");


const collectionUrl = "https://s3.ap-northeast-1.wasabisys.com/je-pds/cog/v1/JAXA.G-Portal_GCOM-C.SGLI_standard.L3-SST.daytime.v3_global_monthly/collection.json";
const band = "SST";
const date = new Date();

import getValue from "./getValue.js";
console.log(await getValue(collectionUrl, date, band, 141.0, 35.361));

import getImage from "./getImage.js";
const res = await getImage(collectionUrl, date, band, 138.727, 35.361, 2.0);
fs.writeFileSync("getImage.png", res.image);
console.log(res.min, res.max, res.unit);

import getCsv from "./getCsv.js";
fs.writeFileSync("getCsv.txt", (await getCsv(collectionUrl, date, band, 141.0, 35.361, 2.0)).data, "utf8");

import getLinks from "./getLinks.js";
fs.writeFileSync("getLinks.txt", getLinks(collectionUrl, date, band), "utf8");

import getJavaScriptCode from "./getJavaScriptCode.js";
fs.writeFileSync("getJavaScriptCode.txt", getJavaScriptCode(collectionUrl, date, band, 138.727, 35.361, 2.0), "utf8");



