
import * as je from "./jaxa.earth.esm.js";

//AW3Dのデータを利用して、指定した緯度経度の場所周辺の標高を画像で返す
export default async (lng: number, lat: number): Promise<Uint8Array> => {

	//指定された緯度経度を中心として±1度のbboxを作る
	const dl = 1.0;
	const bbox: je.Bbox = [lng - dl, lat - dl, lng + dl, lat + dl];

	//AW3Dを指定
	//https://data.earth.jaxa.jp/ja/datasets/#/id/JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global
	const collectionUrl = "https://s3.ap-northeast-1.wasabisys.com/je-pds/cog/v1/JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global/collection.json";
	const band = "DSM";

	//画像サイズは500px四方
	const dataObject = await je.getDataObject({
		collectionUrl,
		band,
		bbox,
		width: 500,
		height: 500,
	});

	//0～6000mを青→赤の虹色に塗るカラーマップ
	const colorMap = new je.image.ColorMap({
		min: 0,
		max: 6000,
		colors: je.Colors.JET,
	});

	//PNG画像のバイナリデータを作成し、Uint8Arrayの型で返す
	return await je.image.createPng(dataObject, colorMap);
};