
import * as je from "./jaxa.earth.esm.js";

//AW3Dのデータを利用して、指定した緯度経度の場所の標高を返す
export default async (lng: number, lat: number): Promise<number> => {

	//指定された緯度経度を中心として±0.001度の狭い区域でbboxを作る
	const dl = 0.001;
	const bbox: je.Bbox = [lng - dl, lat - dl, lng + dl, lat + dl];

	//AW3Dを指定
	//https://data.earth.jaxa.jp/ja/datasets/#/id/JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global
	const collectionUrl = "https://s3.ap-northeast-1.wasabisys.com/je-pds/cog/v1/JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global/collection.json";
	const band = "DSM";

	//DataObjectを取得
	//画像サイズは100px四方
	const dataObject = await je.getDataObject({
		collectionUrl,
		band,
		bbox,
		width: 100,
		height: 100,
	});

	//統計値計算を行う(最小値、最大値、平均値など)
	const stat = je.data.globalStat(dataObject);

	//平均値meanを返す
	return stat.mean;
};