import { createMcpExpressApp } from "@modelcontextprotocol/sdk/server/express.js";
import { StreamableHTTPServerTransport } from "@modelcontextprotocol/sdk/server/streamableHttp.js";
import cors from "cors";
import type { Request, Response } from "express";
import createMcpServer from "./createMcpServer.js";

const port = "3001";
// const host = "localhost"; //Claude Desctopなどのクライアントが同一端末内で実行される場合。
const host = "192.168.10.41"; //Claude Desctopなどのクライアントが別の端末で実行される場合には、この端末のIPアドレスを指定。

const app = createMcpExpressApp({ host });
app.use(cors());

app.all("/mcp", async (req: Request, res: Response) => {
	//生成AIから届くリクエストの内容をコンソールに表示します。
	console.log(req.body);

	//このサンプルはステートレスな機能のみのため、セッションは持たずに都度新しく立ち上げます。
    //ユーザー認証等、ステートフルな機能を作る場合はセッションを管理するための別の実装が必要です。
	const server = createMcpServer();
	const transport = new StreamableHTTPServerTransport();

	res.on("close", () => {
		transport.close().catch(() => { });
		server.close().catch(() => { });
	});

	try {

		await server.connect(transport);
		await transport.handleRequest(req, res, req.body);

	} catch (error) {
		console.error("MCP error:", error);
		if (!res.headersSent) {
			res.status(500).json({
				jsonrpc: "2.0",
				error: { code: -32603, message: "Internal server error" },
				id: null,
			});
		}
	}
});

const httpServer = app.listen(port, (err) => {
	if (err) {
		console.error("Failed to start server:", err);
		process.exit(1);
	}
	console.log(`MCP server listening on http://${host}:${port}/mcp`);
});

const shutdown = () => {
	console.log("\nShutting down...");
	httpServer.close(() => process.exit(0));
};

process.on("SIGINT", shutdown);
process.on("SIGTERM", shutdown);