# Import
from osgeo import gdal

# Generate color table from label information
def gen_ctable(labels):

    # Check labels
    if labels is None:
        return None

    # Set values
    values = [labels[i]["value"] for i in range(len(labels))]

    # Get colors
    colors = []
    for i in range(256):

        # Update ctmp
        if i in values:
            ctmp = htmlccode2rgb(labels[values.index(i)]["color-hint"])

        # Append
        colors.append(ctmp)
    
    # Generate color table
    ctable = gdal.ColorTable()
    for i, color in enumerate(colors):
        ctable.SetColorEntry(i, color)

    # Return
    return ctable

# htmlccode2rgb : Convert HTML color code to RGB
def htmlccode2rgb(pcode):
    R = int(pcode[1:3],16)
    G = int(pcode[3:5],16)
    B = int(pcode[5:7],16)
    return (R,G,B,255)
