import os
import xml.etree.ElementTree as ET

# geo : Read
def geo(dlim):

    # Define name space
    ET.register_namespace('gmd', "http://www.isotc211.org/2005/gmd")
    ET.register_namespace('gml', "http://www.opengis.net/gml/3.2" )
    ET.register_namespace('xsi', "http://www.w3.org/2001/XMLSchema-instance")

    # Get xml
    # Attention! jupyter notebook can't detect __file__
    fn0  = "GEO_METADATA.xml"
    fn   = os.path.join(os.path.dirname(__file__),fn0)
    tree = ET.parse(fn)
    root = tree.getroot()

    # Set beginPosition, endPosition
    root[0][0][0][0][0][0][0][0][1].text = dlim[0]
    root[0][0][0][0][0][0][0][0][2].text = dlim[1]

    # Convert to text
    data0 = "<?xml version='1.0' encoding='utf8'?>\n".encode('utf-8')
    data1 = ET.tostring(root)
    data  = data0+data1

    # Output
    return data