# Import
import numpy as np
from pathlib import Path
from .products.jasmes.read import sgli_std as read_sgli_std
from .products.ptree.read  import fulldisk as read_ahi_fulldisk
from .geotiff.write import normal as write_geotiff
from .utils.progress import bar as progress_bar

# raw data to geotiff
def raw2geotiff(conv_params):
    
    # Search files
    files = np.array(list(Path(conv_params["input_path"]).glob(conv_params["wild_card"])))

    # Show progress
    print(" - Generating GeoTIFF files ... ")

    # Generate each files
    for i in range(len(files)):

        # Read and write each vnames
        for j in range(len(conv_params["variables"])):

            # Read netcdf
            data = detect_function(files[i],
                conv_params["function"   ],
                conv_params["output_path"],
                conv_params["variables"][j]
            )

            # Write as GeoTIFF
            write_geotiff(data)

        # Show progress
        progress_bar(i,len(files))

    # Finish
    return 1

# Detect appropriate function
def detect_function(file, conv_function, out_path, variable):

    # JASMES SGLI standard product
    if conv_function == "jasmes-sgli-std":
        data = read_sgli_std(file,out_path,variable)

    elif conv_function == "himawari8-fulldisk":
        data = read_ahi_fulldisk(file,out_path,variable)

    # Raise error if no function was found
    else:
        raise Exception("Couldn't detect appropriate function")

    # Return
    return data

