# Import
import datetime,calendar

# ----------------------------------------------------------------------------
# set_dlim
# ----------------------------------------------------------------------------
def set_dlim(dfmt,date_str_raw,duration,ext_t):

    #----------------------------------------------------------------------------
    # YYYY-MM/DD : daily, 8-day, half-monthly data screening
    #----------------------------------------------------------------------------
    if dfmt == "YYYY-MM/DD":

        # Set format and datetime object
        STR_FORMAT = '%Y-%m-%d'

        # Set date str
        tmpstr = list(date_str_raw)
        tmpstr[7] = "/"
        dstr = "".join(tmpstr)

        # Calc dlim (daily)
        if duration == "1D":

            # Set date tmp
            date_tmp   = datetime.datetime.strptime(date_str_raw,STR_FORMAT)
            date_delta = datetime.timedelta(hours=23,minutes=59,seconds=59)

            # Set date lim object
            date_lim_tmp = [date_tmp,date_tmp + date_delta]  

        # Calc dlim (8-day)
        elif duration == "8D":

            # Set date tmp
            date_tmp   = datetime.datetime.strptime(date_str_raw,STR_FORMAT)
            date_delta = datetime.timedelta(days=7,hours=23,minutes=59,seconds=59)

            # Set date lim object
            date_lim_tmp = [date_tmp,date_tmp + date_delta]                

        # Calc dlim (half-monthly)
        elif duration == "HM":
            
            # Set date tmp
            date_tmp = datetime.datetime.strptime(date_str_raw,STR_FORMAT)
            
            # Change range (from 1st to 15th)
            if date_tmp.day == 1 :
        
                # Set date lim object
                date_delta   = datetime.timedelta(days=14,hours=23,minutes=59,seconds=59)
                date_lim_tmp = [date_tmp,date_tmp + date_delta]     
            
            # Change range (from 16th to 28/29/30/31)
            else:

                # Set date lim object
                date_lim_tmp = [
                    date_tmp,
                    date_tmp.replace(
                        day    = calendar.monthrange(date_tmp.year, date_tmp.month)[1],
                        hour   = 23,
                        minute = 59,
                        second = 59
                    )
                ]      

    #----------------------------------------------------------------------------
    # YYYY-MM : monthly data screening
    #----------------------------------------------------------------------------
    elif dfmt == "YYYY-MM":

        # Set format and datetime object
        STR_FORMAT = '%Y-%m'
        date_tmp   = datetime.datetime.strptime(date_str_raw,STR_FORMAT)

        # Set date str
        dstr = date_str_raw

        # Change Date range (start:day1 - end:day31)
        date_lim_tmp = [date_tmp.replace(day=1),
                        date_tmp.replace(day=calendar.monthrange(date_tmp.year, date_tmp.month)[1],
                                            hour=23,minute=59,second=59)]

    #----------------------------------------------------------------------------
    # YYYY : Yearly data screening
    #----------------------------------------------------------------------------
    elif dfmt == "YYYY":

        # Set format and datetime object
        STR_FORMAT = '%Y'
        date_tmp   = datetime.datetime.strptime(date_str_raw,STR_FORMAT)

        # Set date str
        dstr = date_str_raw

        # Change Date range (start:day1 - end:day31)
        date_lim_tmp = [date_tmp.replace(month=1,day=1),
                        date_tmp.replace(month=12,day=31,
                                            hour=23,minute=59,second=59)]

    #----------------------------------------------------------------------------
    # DDD : Normal data (daily) screening
    #----------------------------------------------------------------------------
    elif dfmt == "DDD":

        # Return
        return ext_t,date_str_raw

    #----------------------------------------------------------------------------
    # MM-DD : Normal data (half-monthly) screening
    #----------------------------------------------------------------------------
    elif dfmt == "MM-DD":

        # Return
        return ext_t,date_str_raw

    #----------------------------------------------------------------------------
    # MM : Normal data (monthly) screening
    #----------------------------------------------------------------------------
    elif dfmt == "MM":

        # Return
        return ext_t,date_str_raw
    
    # Object to string
    OUT_FORMAT = '%Y-%m-%dT%H:%M:%SZ'
    dlim = [datetime.datetime.strftime(date_lim_tmp[i],OUT_FORMAT) for i in range(len(date_lim_tmp))]

    # Return
    return dlim,dstr