# Import
import boto3
from .utils.progress import bar as progress_bar

# delete
def delete(cloud_key,credential):

    # Parameter settings
    cloud = {
        "bucket": "je-pds",
        "root": "https://s3.twofive.rstorcloud.io/"
    }

    # File detection
    files     = detect_files(cloud,credential,cloud_key)

    # delete files
    files_err = delete_files(files,cloud,credential)


# detect_all_files
def detect_files(cloud,credential,cloud_key):

    # Set RSTOR settings
    rstor = boto3.client(
        "s3",
        aws_access_key_id     = credential["RSTOR_ID"],
        aws_secret_access_key = credential["RSTOR_SECRET"],
        endpoint_url          = cloud["root"]
    )

    # Detect all subdirectories
    files = rstor.list_objects(
        Bucket = cloud["bucket"],
        Prefix = cloud_key,
    )

    # Return
    return files

def delete_files(files,cloud,credential): 

    # Set RSTOR settings
    rstor = boto3.client(
        "s3",
        aws_access_key_id     = credential["RSTOR_ID"],
        aws_secret_access_key = credential["RSTOR_SECRET"],
        endpoint_url          = cloud["root"]
    )

    # Initialize error names
    files_err = []

    # Show progress
    fnum = len(files["Contents"])
    print(f" - Deleting {fnum} files")

    # Put object
    for i in range(fnum):

        try:

            # Delete
            rstor.delete_object(
                Bucket = cloud["bucket"],
                Key    = files["Contents"][i]["Key"]
            )

        except:

            # Record error file
            files_err.extend(files["Contents"][i])

        # Show progress
        progress_bar(i,fnum)

    # Return
    return files_err

