# Import
from pathlib import Path
from .cog.gen    import multi_level as gen_multi_level_cog
from .cog.params.set import Epsg
from .source.detect import folders as detect_folders
from .source.search import search as search_source
from .utils.read import json_raw as read_json

# gen_cog
def gen_cog(product_json_path,endpoint):

    # Show progress
    print(" - COG generation started")

    # Read collection's information
    product_dict = read_json(product_json_path)
    epsg         = product_dict["summaries"]["je:epsg"][0]
    bands        = list(product_dict["assets"].keys())

    # Set ppu limit to inputed ppu_max
    ppu_limit = product_dict["summaries"]["je:ppu_max"][0]
    
    # Set output path
    out_path = Path(endpoint["root_local"])\
               .joinpath(endpoint["bucket"])\
               .joinpath(endpoint["ftype"])\
               .joinpath(endpoint["version_path"])

    # Make each band's cog
    for i in range(len(bands)):

        # Set date folders
        date_folders = detect_folders(product_dict,bands[i])

        # Generate each dates
        for j in range(len(date_folders)):

            # Show Progress
            print(f" - Band : {bands[i]}, Date : {date_folders[j]}")

            # Set source
            source = search_source(product_dict,bands[i],date_folders[j],ppu_limit)

            # Set cog parameters (All internal layer is assumed to be same)
            cog_level = list(source.keys())[0]
            ppu_max   = source[cog_level][0]["ppu_max"]
            bbox_max  = source[cog_level][0]["bbox_max"]
            cog       = Epsg(epsg).set_cog_params(product_dict,ppu_max,bbox_max,out_path,date_folders[j])

            # Generate all Level COG
            gen_multi_level_cog(source,cog)

    # Show progress
    print(" - COG generation ended")
