# import module
from pandas import read_excel
import json
from src.utils.progress import bar as progress_bar

# Generate jsons from xlsx file
def gen_jsons(path_xlsx):

    # Read xlsx to dict
    df   = read_excel(path_xlsx)
    data = df.to_dict(orient="records")

    # Create new dict
    for i in range(len(data)):

        # Reset
        dout = dict()

        # Set params
        dout["id"]          = data[i]["id"]
        dout["description"] = data[i]["description"]
        dout["title"]       = data[i]["title"]
        dout["keywords"]    = parse_char(data[i]["keywords"])

        # Set providers, license
        dout["providers"] = [
            {
                "name": data[i]['providers(1).name'],
                "roles":parse_char(data[i]['providers(1).roles']),
                "url":  data[i]['providers(1).url']
            },
            {
                "name": data[i]['providers(2).name'],
                "roles":parse_char(data[i]['providers(2).roles']),
                "url":  data[i]['providers(2).url']
            },
            {
                "name": data[i]['providers(3).name'],
                "roles":parse_char(data[i]['providers(3).roles']),
                "url":  data[i]['providers(3).url']
            },
        ]
        dout["license"] = data[i]["license"]

        # Set extent, duration
        dout["extent"] = {
            "spatial":{
                "bbox": [parse_char(data[i]['extent.spatial.bbox'],num=True)]
            },
            "temporal":{
                "interval":[parse_char(data[1]['extent.temporal.interval'])]
            }
        }
        dout["duration"] = data[i]["duration"]

        # Set summaries
        dout["summaries"] = {
            "platform": parse_char(data[i]['summaries.platform']),
            "instrument": parse_char(data[i]['summaries.instrument']),
            "je:epsg": [data[i]['summaries.proj_epsg']],
            "je:stac_date_format":[data[i]['summaries.je_stac_date_format']],
            "je:ppu_max":[data[i]['summaries.je_ppu_max']],
            "je:stac_version":["v1.2"]
        }

        # Set publications
        dout["sci:publications"] = []
        for j in range(3):

            # Check DELETE or not
            pub = data[i][f'sci_publications({j+1}).citation']
            if pub != "DELETE":
                dout["sci:publications"].append({"citation":pub})

        # Set assets
        dout["assets"] = {
            data[i]['rasters(1).name']:{
                "title":data[i]['rasters(1).title'],
                "roles":[data[i]['rasters(1).roles']],
                "classification:classes":[],
                "source":{
                    "path":[
                        {
                            "dir":"input-path",
                            "wildcard":"input-wildcard",
                            "layer_number":1
                        }
                    ],
                    "dn":{
                        "data_type":data[i]['rasters(1).dn.data_type'],
                        "nodata":data[i]['rasters(1).dn.nodata'],
                        "error":parse_char(data[i]['rasters(1).dn.error'],num=True),
                    },
                    "dn2value":{
                        "slope":data[i]['rasters(1).dn2value.slope'],
                        "offset":data[i]['rasters(1).dn2value.offset'],
                    }
                },
                "cog":{
                    "value":{
                        "def_interp":data[i]['rasters(1).value.def_interp'],
                        "unit":data[i]['rasters(1).value.unit'],
                        "labels": None,
                    },
                    "dn2value":{
                        "slope":data[i]['rasters(1).dn2value.slope'],
                        "offset":data[i]['rasters(1).dn2value.offset'],
                    },
                    "dn":{
                        "data_type":data[i]['rasters(1).dn.data_type'],
                        "min":data[i]['rasters(1).dn.min'],
                        "max":data[i]['rasters(1).dn.max'],
                        "nodata":data[i]['rasters(1).dn.nodata'],
                        "error":parse_char(data[i]['rasters(1).dn.error'],num=True),
                    },
                    "pint":data[i]['rasters(1).pint'],
                }
            }
        }

        # Set link
        dout["links"] = [
            {
                "rel":"license",
                "href":data[i]["license"],
                "type":"text/html"
            }
        ]

        # Set NaN to null
        tmp = json.dumps(dout)
        tmp = tmp.replace("NaN","null")
        tmp = json.loads(tmp)

        # Save json
        cname = dout["id"]
        jname = f"./src/collection/normal/{cname}.json"
        with open(jname, 'w') as outfile:
            json.dump(tmp, outfile, indent=4)

        # Show progress
        progress_bar(i,len(data))


# Parse character
def parse_char(c_in,num=False):

    # parse
    if type(c_in) == str:
    
        # Check []
        if "[" in c_in:

            # delete [] and split
            c_out = c_in[1:-1].split(",")

            # Change str to num , if num is True
            if (num is True) & (type(c_out) is list):
                c_out = [float(i) for i in c_out]

        else:

            # Convert to float
            if num is True:
                c_out = float(c_in)

            # As is (str)
            else:
                c_out = c_in

    # As is (not str)
    else:
        c_out = c_in

    # return
    return c_out
