# Import
from osgeo import gdal,osr

# normal (MINISBLACK)
def normal(input):

    # Create folders
    if not input["fn_out"].parent.exists():
        input["fn_out"].parent.mkdir(parents=True)    

    # Set geotiff options
    gopt = ["TILED=YES",
            "PHOTOMETRIC=MINISBLACK",
            "BLOCKXSIZE=256",
            "BLOCKYSIZE=256",
            "PREDICTOR=1",
            "COMPRESS=DEFLATE"]  

    # Save as geotiff
    dtype  = gdal_dtype(input["img"].dtype)
    output = gdal.GetDriverByName('GTiff').Create(str(input["fn_out"]),input["img"].shape[1],input["img"].shape[0],1,dtype,options = gopt)

    # Set spatial reference
    output.SetGeoTransform((input["bbox"][0], input["ddeg"], 0, input["bbox"][3], 0, -input["ddeg"]))
    srs = osr.SpatialReference() 
    srs.ImportFromEPSG(4326)
    output.SetProjection(srs.ExportToWkt()) 

    # Set Metadata (for AREA)
    output.SetMetadata({'AREA_OR_POINT':'AREA'})

    # Output tiff
    output.GetRasterBand(1).WriteArray(input["img"])
    output.FlushCache()                     
    output = None    


# Set gdal data type
def gdal_dtype(dtype):

    # Check data type of images
    if   dtype ==   "int16": g_dtype = gdal.GDT_Int16
    elif dtype ==   "int32": g_dtype = gdal.GDT_Int32
    elif dtype ==   "int64": g_dtype = gdal.GDT_Int64
    elif dtype ==  "uint8" : g_dtype = gdal.GDT_Byte
    elif dtype ==  "uint16": g_dtype = gdal.GDT_UInt16
    elif dtype ==  "uint32": g_dtype = gdal.GDT_UInt32
    elif dtype ==  "uint64": g_dtype = gdal.GDT_UInt64
    elif dtype == "float32": g_dtype = gdal.GDT_Float32
    elif dtype == "float64": g_dtype = gdal.GDT_Float64

    # Return
    return g_dtype

