# Import
import numpy as np
from pathlib import Path

# Detect folders
def folders(product_dict,band):

    # Select band's source path
    band_paths = product_dict["assets"][band]["source"]["path"]

    # Attention! Check all source's directory date as same or not
    dfolder_all = []
    for i in range(len(band_paths)):

        # Temporal path
        path_tmp = Path(band_paths[i]["dir"])

        # Detect each source's folder
        dfolder_tmp = [p.parts[-1] for p in path_tmp.iterdir() if p.is_dir()]

        # Append
        dfolder_all.append(dfolder_tmp)

    # If different, raise error
    dfolder_trns = np.array(dfolder_all).transpose()
    for i in range(len(dfolder_trns)):
        fnum = len(set(dfolder_trns[i]))
        if fnum != 1:
            raise Exception("Error! All source folder must have same folders !")
    
    # Detect all folders
    date_folders = dfolder_all[0]

    # Retrun
    return date_folders