
from pathlib import Path
import numpy as np
from ..cog.read   import info  as read_cog_info
from ..cog.params.set  import Epsg

# Source search
def search(product_dict, band, date_path, ppu_limit):
        
    # Get each bands path
    band_paths = product_dict["assets"][band]["source"]["path"]

    # Get each file names and get information
    input_tmp = []
    for i in range(len(band_paths)):

        # Get each asset's file names
        dir_tmp  = band_paths[i]["dir"]+date_path
        wcard    = band_paths[i]["wildcard"]
        fn_input = np.array(list(Path(dir_tmp).glob(wcard)))

        # Get each cog's general information
        cog = Epsg(product_dict["summaries"]["je:epsg"][0])

        # Get all tif's bbox and ppd (pixel per degree)
        bbox, srs, ppu_max, regen_rgb = read_cog_info(band,fn_input,cog.epsg,cog.unit)

        # Get maximum bbox
        bbox_max = [bbox[:,0].min(),bbox[:,1].min(),
                    bbox[:,2].max(),bbox[:,3].max()]

        # Round ppu_max 
        # Attention! Must be comment out if you over COG Level-4)
        if (not (not ppu_limit)) & (ppu_max > ppu_limit):
            ppu_max = ppu_limit
        
        # Detect maximum cog level
        idx_cog       = np.where(cog.levels[1] >= ppu_max)[0].min()
        cog_level_max = cog.levels[0][idx_cog]
        cog_lev_str   = f"COG-level-{'{:1.0f}'.format(cog_level_max)}"

        # Set each band's input
        input_tmp_tmp = {
            "band": band,
            "params": {
                "dn": product_dict["assets"][band]["source"]["dn"],
                "dn2value": product_dict["assets"][band]["source"]["dn2value"]
            },
            "fnames": fn_input,
            "layer_number": band_paths[i]["layer_number"],
            "bbox": bbox,
            "bbox_max": bbox_max,
            "srs": srs,
            "ppu_max": ppu_max,
            "regen_rgb": regen_rgb
        }

        # Append
        input_tmp.append(input_tmp_tmp)

    # Output
    input = {f"{cog_lev_str}": input_tmp}

    # Return
    return input

