# Import
import pystac
from pathlib import Path
from .item.gen import tiff as gen_tiff_item
from ...utils.progress import bar as progress_bar

# date of two depth
def date_of_two_depth(collection,endpoint,product_dict,date_folder,date_id):

    # Make date catalogs
    date_catalog = pystac.Catalog(
        id = date_id,
        title = f"Catalog of COG files in {date_id}",
        description = "TBD",
    )

    # Get all next date folders
    date_folders = [p.parts[-1] for p in date_folder.iterdir() if p.is_dir()]    

    # Make and add child
    for i in range(len(date_folders)):

        # Conbine cog's path
        child_folder = date_folder.joinpath(date_folders[i])

        # Make catalog
        child_catalog = date_of_one_depth(collection,endpoint,product_dict,child_folder,date_folders[i])

        # Add as child
        date_catalog.add_child(child_catalog)

    # Return
    return date_catalog

# date of single depth
def date_of_one_depth(collection,endpoint,product_dict,date_folder,date_id):

    # Output date catalog json file name
    #dc_file = date_folder.joinpath("catalog.json")

    # Check json if exists or not
    #if dc_file.is_file():

        # Read json from file
        #date_catalog = pystac.Catalog.from_file(str(dc_file))

    # Make json because json file was not found
    #else:

    # Make date catalogs
    date_catalog = pystac.Catalog(
        id = date_id,
        title = f"Catalog of COG files in {date_id}",
        description = "TBD"
    )

    # Get all cog level folders
    cog_lev_folders = [p.parts[-1] for p in date_folder.iterdir() if p.is_dir()]

    # Make and add child
    for i in range(len(cog_lev_folders)):

        # Make path
        cog_lev_folder = date_folder.joinpath(cog_lev_folders[i])

        # Make catalog
        cog_lev_catalog = cog_lev(collection,endpoint,product_dict,cog_lev_folder)

        # Add as child
        date_catalog.add_child(cog_lev_catalog)

    # Return
    return date_catalog

# cog level catalogs
def cog_lev(collection,endpoint,product_dict,cog_lev_folder):

    # Set id and date
    id = cog_lev_folder.parts[-1]

    # Make cog level catalog
    cog_lev_catalog = pystac.Catalog(
        id = id,
        title = f"Catalog of COG Level-{id} files",
        description = "TBD",
    )

    # Get all lon folders
    lon_folders = [p.parts[-1] for p in cog_lev_folder.iterdir() if p.is_dir()]

    # Get date format
    dfmt = product_dict["summaries"]["je:stac_date_format"][0]
    dfmt_snum = dfmt.count("/")
    if   dfmt_snum == 0: 
        date_id = "/".join(cog_lev_folder.parts[-2:-1])
    elif dfmt_snum == 1:
        date_id = "/".join(cog_lev_folder.parts[-3:-1])

    # Show progress
    print(f" - COG level {id} on {date_id} STAC generating ...")

    # Make and add child
    for i in range(len(lon_folders)):

        # Combine cog's path
        child_folder = cog_lev_folder.joinpath(lon_folders[i])

        # Make catalog
        lon_catalog = lon(collection,endpoint,product_dict,child_folder,lon_folders[i])

        # Add as child
        cog_lev_catalog.add_child(lon_catalog)

        # Show progress
        progress_bar(i,len(lon_folders))

    # Return
    return cog_lev_catalog

# lon catalogs
def lon(collection,endpoint,product_dict,lon_folder_path,lon_folder):

    # Make lon catalog
    lon_catalog = pystac.Catalog(
        id = lon_folder,
        title = f"Catalog of COG in {lon_folder} flies",
        description = "TBD",
    )

    # Get tiff names include lon_folder string
    wild_card  = lon_folder.split("-")[0]+"-*-"+lon_folder.split("-")[1]+"-*-*.ti*"
    tiff_names = list(Path(lon_folder_path).glob(wild_card))
    tiff_names = [p.parts[-1] for p in tiff_names]

    # Get lat_strs
    lat_strs = ["-".join(tiff_names[p].split("-")[1:4:2]) for p in range(len(tiff_names))]
    lat_strs = list(set(lat_strs))

    # Make and add child
    for i in range(len(lat_strs)):

        # Make catalog
        lat_item = gen_tiff_item(collection,endpoint,product_dict,lon_folder_path,lon_folder,lat_strs[i])

        # Add as child
        lon_catalog.add_item(lat_item)

    # Return
    return lon_catalog
