# import
import os
import boto3
from ..utils.progress import bar as progress_bar

# Get/save all log files from cloud to local
def all(Params):

    # Get rstor id, secret from environment variables
    WASABI_ID     = os.environ[Params.ID_NAME]
    WASABI_SECRET = os.environ[Params.SECRET_NAME]

    # Set RSTOR settings
    wasabi = boto3.client(
        "s3",
        aws_access_key_id     = WASABI_ID,
        aws_secret_access_key = WASABI_SECRET,
        endpoint_url          = Params.ENDPOINT
        )

    # Keep getting data until no log in bucket
    print(" - Get and save log files ...")
    while True:

        # Get log's name list
        logs = wasabi.list_objects(Bucket=Params.BUCKET_LOG)

        # Check presense of logs in bucket
        if logs.get("Contents") is not None:

            # Aquire numbers of logs
            logs_length = len(logs["Contents"])

            # Print numbers of logs
            print(f" - {logs_length} logs found!")

            # Get/save/delete log files
            for i in range(logs_length):

                # Get log file binary
                fn_read = logs["Contents"][i]["Key"]
                objtmp  = wasabi.get_object(Bucket = Params.BUCKET_LOG, Key = fn_read)

                # Save log file in local directory
                fn_save = Params.LOGS_FOLDER+"/"+fn_read.replace(":","_")+".txt"
                f = open(fn_save,'x')
                f.write(objtmp["Body"].read().decode("utf-8"))
                f.close()

                # Delete log file
                wasabi.delete_object(Bucket = Params.BUCKET_LOG, Key = fn_read)

                # Show progress
                progress_bar(i,logs_length)

        else:
            break

    # Finish getting log
    print(" - Finished!")
