class Params:

    # Log folder directory
    LOGS_FOLDER = "log"

    # Wasabi information (ID, Secret is set in environment value)
    ENDPOINT    = "https://s3.ap-northeast-1.wasabisys.com"
    BUCKET_LOG  = "je-log"
    ID_NAME     = "WASABI_ID" 
    SECRET_NAME = "WASABI_SECRET"

    # PostgreSQL Database settings
    DB_HOST = "db"
    DB_PORT = "5432"
    DB_NAME = "postgres"
    DB_USER = "postgres"
    DB_PWD  = "metabase"
    
    # Star schema's dimension table schema
    SCHEMA_OF_DIM_TABLE = [
        {
            "table_name":"user_ip",
            "key_name"  :"RemoteIp",
            "schema"    :[["RemoteIp"   ,"inet"],
                          ["Host"       ,"text"],
                          ["Domain"     ,"text"],
                          ["CountryCode","text"]]
        },
        {
            "table_name":"operations",
            "key_name"  :"Operation",
            "schema"    :[["Operation","text"]]
        },
        {
            "table_name":"requesters",
            "key_name"  :"Requester",
            "schema"    :[["Requester","text"]]
        },
        {
            "table_name":"http_statuss",
            "key_name"  :"HttpStatus",
            "schema"    :[["HttpStatus","text"]]
        },
        {
            "table_name":"error_codes",
            "key_name"  :"ErrorCode",
            "schema"    :[["ErrorCode","text"]]
        },
        {
            "table_name":"referers",
            "key_name"  :"Referer",
            "schema"    :[["Referer","text"]]
        },
        {
            "table_name":"user_agents",
            "key_name"  :"UserAgent",
            "schema"    :[["UserAgent","text"]]
        },
        {
            "table_name":"file_types",
            "key_name"  :"FileType",
            "schema"    :[["FileType","text"]]
        },
        {
            "table_name":"collections",
            "key_name"  :"Collection",
            "schema"    :[["Collection","text"]]
        },
        {
            "table_name":"bands",
            "key_name"  :"Band",
            "schema"    :[["Band","text"]]
        },
    ]

    # Database table of logfiles name and models
    LOGNAMES_TABLE = "logfiles"
    LOGNAMES_MODEL = [["fname","text"]]

    # PDS, STAC bucket's name
    BUCKET_PDS  = "je-pds"
    BUCKET_STAC = "je-stac"

