# Import
import os
import numpy as np
from .sql.database import DataBase

# Check log in sql
def lognames(Params):

    # logfiles name, model
    tablename = Params.LOGNAMES_TABLE
    models    = Params.LOGNAMES_MODEL

    # Make instance
    database = DataBase()
    
    # Detect all logs file names in log folder
    local_fnames = os.listdir(path=Params.LOGS_FOLDER)
    local_fnames = np.array([local_fnames]).transpose()

    #local_fnames = local_fnames[0:100]

    # Get table list of database
    db_tables = database.list_tables()

    # Make logfiles table if not exist
    # eq1: No data in db_tables
    eq1_table = not any(db_tables)
    # eq2: tablename is not included in db
    eq2_table = tablename not in db_tables 
    if eq1_table | eq2_table:
        log_model = [["ID","serial PRIMARY KEY"]]
        log_model.extend(Params.LOGNAMES_MODEL)
        database.create_table(tablename,log_model)

    # Get list of table(logfiles)'s fnames
    db_fnames = database.list_table_values(tablename,models[0][0])
    db_fnames = db_fnames.astype("str")

    # Get file names to be uploaded
    log_fnames = []
    if any(db_fnames): 
        for i in range(len(local_fnames)):
            if local_fnames[i] not in db_fnames:
                log_fnames.append(local_fnames[i])
    else:
        log_fnames = local_fnames

    # Return log file names to be uploaded
    return log_fnames