# Import
from .txt.read_wasabi import single    as read_single_txt
from .sql.insert      import data      as insert_data
from .check           import lognames  as check_lognames_in_database
from .update          import ip        as update_ip_in_database
from .generate        import star_fact as generate_star_fact
from ..utils.progress import bar       as progress_bar

# Convert txt log to sql database
def all(Params):
    
    # Check local log fles and uploaded log files and return necessary files to upload
    logs_fname = check_lognames_in_database(Params)

    # Print progress
    print(" - Deploy local data from txt to sql database ... ")

    # Read all log files and input to sql
    for i in range(len(logs_fname)):

        # Read single log file
        fname = f"{Params.LOGS_FOLDER}/{logs_fname[i][0]}"
        bucket,table_names,models,data = read_single_txt(fname,Params)

        # Insert if data is available
        if data.shape != 0:

            # If bucket in pds, make star schema's table
            if bucket in Params.BUCKET_PDS:
                
                # Generate and update star schema's fact table and dimension table
                models_new,data_new = generate_star_fact(models,data,Params)

                # Input log data to PostgreSQL database
                insert_data(table_names,models_new,data_new)  

            else:

                # Input log data to PostgreSQL database
                insert_data(table_names,models,data)             

        # Input fname data to PostgreSQL database
        insert_data([Params.LOGNAMES_TABLE],Params.LOGNAMES_MODEL,[logs_fname[i]])

        # Show progress
        progress_bar(i,len(logs_fname))

    # Print progress
    print(" - Finished!")