# Import modules
import numpy as np
from .sql.database import DataBase

# Generate star schema's fact table
def star_fact(model,data,Params):
    
    # Define schema of dimension table
    schema_of_dim_table = Params.SCHEMA_OF_DIM_TABLE

    # Make instance
    database = DataBase()

    # Repeat process for the number of dimension tables
    for i_d in range(len(schema_of_dim_table)):

        # Extract selected key
        key_names = np.array([i[0] for i in model])
        key_idx   = np.where(key_names == schema_of_dim_table[i_d]["key_name"])[0][0]
        data_ext  = np.array([i[key_idx] for i in data])

        # Detect unique values
        data_uniq = list(set(data_ext))

        # Generate and update star dimension table
        id_uniq = star_dimension(schema_of_dim_table[i_d],data_uniq,database)

        # Update extracted data's data
        data_id = np.zeros(len(data_ext), dtype="int")
        for i in range(len(data_uniq)):
            id_idx = np.where(data_ext == data_uniq[i])[0]
            data_id[id_idx] = id_uniq[i]

        # Update fact table's data
        for i in range(len(data)):
            data[i][key_idx] = data_id[i]

        # Update model name
        model[key_idx][0] = model[key_idx][0]+"_ID"
        model[key_idx][1] = 'integer'

    # Commit
    database.commit()

    # Return new data
    return model,data

# Generate star schema's dimension table
def star_dimension(star_model,data,database):

    # Define tablename and models
    tablename = star_model["table_name"]
    models    = star_model["schema"]
    keyname   = star_model["key_name"]

    # Get table list of database
    db_tables = database.list_tables()

    # Make ipaddress table if not exist
    # eq1: No data in db_tables
    eq1_table = not any(db_tables)
    # eq2: tablename is not included in db
    eq2_table = tablename not in db_tables 
    if eq1_table | eq2_table:
        ip_model = [["ID","serial PRIMARY KEY"]]
        ip_model.extend(models)
        database.create_table(tablename,ip_model)

    # Get table table(ipaddress)
    db_values = database.list_table_values(tablename,keyname)
    db_values = db_values.astype("str")

    # Get IP address to be updated and generate ID
    for i in range(len(data)):
        if data[i] not in db_values:
            input_data = [[data[i]]+["Unknown"]*(len(models)-1)]
            database.insert_data([tablename],models,input_data)

    # Detect each value's primary id
    id_unique = []
    for i in range(len(data)):
        id_unique.append(database.search_id(tablename,models[0][0],data[i]))

    # Return unique id
    return id_unique