# Import
import psycopg2
import numpy as np
from ...conf import Params

# DataBase class
class DataBase:

    # Constructer
    def __init__(self):
        
        # Make connection
        db = psycopg2.connect(" host     ="+ Params.DB_HOST +
                              " port     ="+ Params.DB_PORT +
                              " dbname   ="+ Params.DB_NAME +
                              " user     ="+ Params.DB_USER +
                              " password ="+ Params.DB_PWD  )
        
        # Return
        self.db  = db
        self.cur = db.cursor()

    # List table
    def list_tables(self):
        sql_message = """
            SELECT table_name FROM information_schema.tables
            WHERE table_schema = 'public'
        """
        self.cur.execute(sql_message)
        tables = self.cur.fetchall()
        tables = np.array(tables,dtype="unicode")
        return tables

    # List table's values from key
    def list_table_values(self,tablename,key):
        sql_message = f"SELECT {key} FROM {tablename}"
        self.cur.execute(sql_message)
        values = self.cur.fetchall()
        values = np.array(values)
        return values

    # Search table's values (only text) need to update!
    def search_id(self,tablename,key,value):
        sql_message = f"SELECT ID FROM {tablename} WHERE {key}='{value}' LIMIT 1;"
        self.cur.execute(sql_message)
        value = self.cur.fetchall()
        return value[0][0]
    
    # Create table
    def create_table(self,tablename,models):

        # Generate model string to make table
        for i in range(len(models)):
            str_tmp = f"{models[i][0]} {models[i][1]}"
            if i == 0:
                model_str = str_tmp
            else:
                model_str = f"{model_str}, {str_tmp}"

        # Execute creation
        sql_message = f"CREATE TABLE {tablename} ({model_str})"
        self.cur.execute(sql_message)
        self.db.commit()

    # Delete table
    def delete_table(self,tablename):
        self.cur.execute(f"DROP TABLE {tablename}")
        self.db.commit()

    # Print all data of table
    def print_table(self,tablename):
        self.cur.execute(f'SELECT * FROM {tablename}')
        rows = self.cur.fetchall()    
        for row in rows:
            print(row)

    # Insert data to table
    def insert_data(self,tablenames,models,datas):

        # Set keys strs
        keys_str  = ",".join([i[0] for i in models])

        # Set types strs
        types = [i[1] for i in models]
        types_str  = ''
        for i in range(len(types)):
            if types[i] == 'geometry':
                types_str = types_str + 'ST_GeomFromGeoJSON(%s),'
            else:
                types_str = types_str + '%s,'
        types_str = types_str[:-1]

        # Sample json
        #geom = {"type": "Polygon","coordinates": [[[139,36],[139,35],[140,35],[139,36],[139,36]]]}
        #data = [[json.dumps(geom),]]

        # Insert all datas into database
        for i in range(len(datas)):
            if len(tablenames) == 1:
                self.cur.execute(f"INSERT INTO {tablenames[0]} ({keys_str}) VALUES({types_str})",datas[i])
            else:
                self.cur.execute(f"INSERT INTO {tablenames[i]} ({keys_str}) VALUES({types_str})",datas[i])

    # Commit
    def commit(self):
        self.db.commit()

    # Close db and cur
    def close(self):
        self.cur.close()
        self.db.close()
    