# Import
import os
import numpy as np
from .sql.database import DataBase

# Update child




# Check log in sql
def ip(data_models,data,Params):

    # logfiles name, model
    tablename = Params.IPNAMES_TABLE
    models    = Params.IPNAMES_MODEL
    keyname   = Params.IPNAMES_KEY   

    # Get log file's unique ip address
    key_all   = np.array([i[0]  for i in data_models])
    idx_ip    = np.where(key_all == "RemoteIp")[0][0]
    ip_all    = data[:,idx_ip]
    ip_unique = list(set(ip_all))

    # Make instance
    database = DataBase()

    # Get table list of database
    db_tables = database.list_tables()

    # Make ipaddress table if not exist
    # eq1: No data in db_tables
    eq1_table = not any(db_tables)
    # eq2: tablename is not included in db
    eq2_table = tablename not in db_tables 
    if eq1_table | eq2_table:
        ip_model = [["ID","serial PRIMARY KEY"]]
        ip_model.extend(models)
        database.create_table(tablename,ip_model)

    # Get table table(ipaddress)
    db_values = database.list_table_values(tablename,keyname)
    db_values = db_values.astype("str")

    # Get IP address to be updated
    for i in range(len(ip_unique)):
        if ip_unique[i] not in db_values:
            input_data = [[ip_unique[i],"Unknown","Unknown","Unknown"]]
            database.insert_data([tablename],models,input_data)
            
