
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-01-01T00:00:00","2021-01-01T00:00:00"]
ppu  = 20

# Set information of collection,band
collection = "NASA.EOSDIS_Aqua.MODIS_MYD11C1-LST.daytime.v061_global_half-monthly-normal"
band       = "LST_2012_2021"

# Get feature collection data
geoj_path = "test.geojson"
geoj = je.FeatureCollection().read(geoj_path).select()

# Get an image
data = je.ImageCollection(collection=collection,ssl_verify=True)\
         .filter_date(dlim=dlim)\
         .filter_resolution(ppu=ppu)\
         .filter_bounds(geoj=geoj[0])\
         .select(band=band)\
         .get_images()

# Process and show an image
img = je.ImageProcess(data)\
        .show_images()

