
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-02-01T00:00:00","2021-02-01T00:00:00"]
ppu  = 10
bbox = [110, 20, 160, 50]
mq   = "range"
val  = [0.1,1000]

# Set information of collection,band for data
collection_d = "JAXA.EORC_GSMaP_standard.Gauge.00Z-23Z.v6_half-monthly-normal"
band_d       = "PRECIP_2012_2021"

# Get an image for data
data_d = je.ImageCollection(collection=collection_d,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_d)\
           .get_images()

# Get information of collections,bands for mask
collection_m = "JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global"
band_m       = "DSM"

# Get an image for mask
data_m = je.ImageCollection(collection=collection_m,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_m)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data_d)\
        .mask_images(data_m,method_query=mq, values=val)\
        .show_images()
