
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2019-01-01T00:00:00","2021-02-01T00:00:00"]
ppu  = 360
bbox = [139.5, 35, 140.5, 36]
mq   = "values_equal"
val  = [190]

# Set information of collection,band for data
collection_d = "JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global"
band_d       = "DSM"

# Get an image for data
data_d = je.ImageCollection(collection=collection_d,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_d)\
           .get_images()

# Set information of collection,band for mask
collection_m = "Copernicus.C3S_PROBA-V_LCCS_global_yearly"
band_m       = "LCCS"

# Get an image for mask
data_m = je.ImageCollection(collection=collection_m,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_m)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data_d)\
        .mask_images(data_m,method_query=mq, values=val)\
        .show_images()
