
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2019-01-01T00:00:00","2021-02-01T00:00:00"]
ppu  = 360
bbox = [139.5, 35, 140.5, 36]
mq   = "bits_equal"
val  = [0,0,0,0,0,0,0,0]

# Set information of collection,band for data, mask
collection = "JAXA.EORC_ALOS.PRISM_AW3D30.v3.2_global"
band_d = "DSM"
band_m = "MSK"

# Get an image for data
data_d = je.ImageCollection(collection=collection,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_d)\
           .get_images()

# Get an image for mask
data_m = je.ImageCollection(collection=collection,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band_m)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data_d)\
        .mask_images(data_m,method_query=mq, values=val)\
        .show_images()
