
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-08-01T00:00:00","2021-08-01T00:00:00"]
bbox = [-180, -90, 180, 90]

# Set information of collection,band for data
collection_d = "JAXA.JASMES_Terra.MODIS-Aqua.MODIS_ndvi.v811_global_monthly"
band_d       = "ndvi"

# Get an image for data
data_d = je.ImageCollection(collection=collection_d,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution()\
           .filter_bounds(bbox=bbox)\
           .select(band=band_d)\
           .get_images()

# Set information of collection,band for reference
collection_r = "JAXA.JASMES_Terra.MODIS-Aqua.MODIS_ndvi.v811_global_monthly-normal"
band_r       = "ndvi_2012_2021"

# Get an image for reference
data_r = je.ImageCollection(collection=collection_r,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution()\
           .filter_bounds(bbox=bbox)\
           .select(band=band_r)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data_d)\
        .diff_images(data_r)\
        .show_images()
