
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-01-01T00:00:00","2021-12-31T00:00:00"]
bbox = [120,20,150,50]
ppu  = 10

# Get information of collections,bands for data
collection = "JAXA.JASMES_Aqua.MODIS_swr.v811_global_half-monthly-normal"
band       = "swr_2012_2021"

# Get an image for data
data = je.ImageCollection(collection=collection,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution(ppu=ppu)\
           .filter_bounds(bbox=bbox)\
           .select(band=band)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data)\
        .calc_spatial_stats()\
        .show_spatial_stats()

# Print timeseries numpy array
print(img.timeseries["mean"])
print(img.timeseries["std"])
print(img.timeseries["min"])
print(img.timeseries["max"])
print(img.timeseries["median"])