# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-01-01T00:00:00","2021-01-01T00:00:00"]
ppu  = 5
bbox = [110, 20, 160, 50]

# Set information of collections,bands
collection = "NASA.EOSDIS_Terra.MODIS_MOD11C1-LST.daytime.v061_global_half-monthly"
band       = "LST"

# Get an image
data = je.ImageCollection(collection=collection,ssl_verify=True)\
         .filter_date(dlim=dlim)\
         .filter_resolution(ppu=ppu)\
         .filter_bounds(bbox=bbox)\
         .select(band=band)\
         .get_images()

# Process and show an image
img = je.ImageProcess(data)\
        .show_images()

