
# Load module
from jaxa.earth import je

# Set query parameters
dlim = ["2021-08-01T00:00:00","2021-08-10T00:00:00"]
bbox = [-180, -90, 180, 90]

# Set information of collection,band for data
collection = "JAXA.G-Portal_GCOM-W.AMSR2_standard.L3-SMC.daytime.v3_global_daily"
band       = "SMC"

# Get an image for data
data = je.ImageCollection(collection=collection,ssl_verify=True)\
           .filter_date(dlim=dlim)\
           .filter_resolution()\
           .filter_bounds(bbox=bbox)\
           .select(band=band)\
           .get_images()

# Process and show an image
img = je.ImageProcess(data)\
        .calc_temporal_stats("mean")\
        .show_images()
